---
title: GraphQL malicious query protection · Cloudflare API Shield docs
description: GraphQL is a query language for APIs. In addition to protecting
  RESTful APIs, Cloudflare can also protect GraphQL APIs.
lastUpdated: 2025-07-03T18:24:39.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/api-shield/security/graphql-protection/
  md: https://developers.cloudflare.com/api-shield/security/graphql-protection/index.md
---

GraphQL is a query language for APIs. In addition to protecting RESTful APIs, Cloudflare can also protect GraphQL APIs.

GraphQL malicious query protection scans your GraphQL traffic for queries that could overload your origin and result in a denial of service. You can build rules that limit the query depth and size of incoming GraphQL queries in order to block suspiciously large or complex queries.

## Availability

GraphQL malicious query protection is available for all API Shield customers. Enterprise customers who have not purchased API Shield can preview [API Shield as a non-contract service](https://dash.cloudflare.com/?to=/:account/:zone/security/api-shield) in the Cloudflare dashboard or by contacting your account team.

## Limitations

Our initial release is limited to parsing GraphQL `POST` bodies smaller than 5 KB. This limit will be lifted in a future release. Additionally, we currently inspect only `POST` requests with `content-types` of `application/json` or `application/graphql` where the queries do not contain fragments or multiple operations. Parsing and rules are limited to paths ending in `/graphql`.
