---
title: Account analytics (beta) · Cloudflare Analytics docs
description: Cloudflare account analytics lets you access a wide range of
  aggregated metrics from all the sites under a specific Cloudflare account.
lastUpdated: 2025-09-04T10:57:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/analytics/account-and-zone-analytics/account-analytics/
  md: https://developers.cloudflare.com/analytics/account-and-zone-analytics/account-analytics/index.md
---

Cloudflare account analytics lets you access a wide range of aggregated metrics from all the sites under a specific Cloudflare account.

Note

For general information about all of Cloudflare's analytics offerings, refer to [About Cloudflare Analytics](https://developers.cloudflare.com/analytics/faq/about-analytics/).

***

## View your account analytics

To view metrics for your site, in the Cloudflare dashboard, go to the **Account Analytics** page.

[Go to **Account analytics**](https://dash.cloudflare.com/?to=/:account/analytics)

Once it loads, the Account Analytics app displays a collection of categorized charts with aggregated metrics for your account. To understand the various metrics available, refer to *Review your account metrics* below.

***

## Review your account metrics

This section outlines the aggregated metrics under each category. Before reviewing your metrics, let's define a couple of concepts used in some panels:

* *Rate* -  Reflects the ratio between the amount for a specific data category and the total.
* *Bandwidth* - Refers to the number of bytes sent from the Cloudflare edge network to the requesting client.

Also, note that:

* To filter metrics for a specific time period, use the dropdown in the top right.
* Most metrics are grouped into panels representing different aspects of the underlying data.

### Summary of metrics

Below is a brief description of the major elements comprising the metrics available.

#### HTTP Traffic

These charts aggregate data for HTTP traffic, and include:

![Chart showing last week's data for HTTP traffic](https://developers.cloudflare.com/_astro/hc-dash-account-analytics-map.CcPRTQU-_ZfK8qO.webp)

* Spark lines for *Requests*, *Bandwidth*, *Page views*, and *Visitors* (*Unique IPs)*
* An interactive map that breaks down the number of requests by country
* A table combining numerical and spark line data, sorted by total number of requests per country

#### Security

![Panel displaying lines highlighting encryption metrics: requests, requests rate, bandwidth, and bandwidth rate](https://developers.cloudflare.com/_astro/hc-dash-account-analytics_security_panel.5rFJ7hHV_1uWeuE.webp)

This panel features spark lines highlighting various encryption metrics, including: *requests*, *requests rate*, *bandwidth*, and *bandwidth rate*.  These also include a comparative percentage change based on the previous period.

#### Cache

![Panel displaying lines for caching metrics: requests, requests rate, bandwidth, and bandwidth rate](https://developers.cloudflare.com/_astro/hc-dash-account-analytics_cache_card.BOCedSTx_g6Jww.webp)

This panel features spark lines for various caching metrics, including: *requests*, *requests rate*, *bandwidth*, and *bandwidth rate*.  These also include a comparative percentage change based on the previous equivalent period.  For example, if you selected *Last week* as your time period, the previous period refers to the *week* before.

#### Errors

![Panel displaying lines for 4xx and 5xx error rates](https://developers.cloudflare.com/_astro/hc-account-analytics_errors_card.D2i2BrS9_Z26qzOn.webp)

This panel displays spark lines for 4xx and 5xx error rates, respectively. Learn more about [HTTP Status Codes](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/). 

#### Network

![Statistics showing the percentage of requests that use a specific version of HTTP](https://developers.cloudflare.com/_astro/hc-dash-account-analytics_network_card.Fso_4DUE_Z1tQwHn.webp)

#### Client HTTP Version Used

These statistics show the percentage of requests that use a specific version of HTTP.

#### Traffic Served Over SSL

These statistics show the percentage of traffic that is encrypted using a specific version of SSL or TLS.

#### Content Type Breakdown

These statistics show the number of requests based on the resource content type.
